/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    private final Path file;
    private final Path dir;
    private final WatchService watcher;
    private WatchKey key;

    public FileWatcher(Path file) throws IOException {
        this.file = file;
        this.dir = Files.isSymbolicLink(file) ? file.toRealPath(new LinkOption[0]).getParent() : file.getParent();
        this.watcher = FileSystems.getDefault().newWatchService();
    }

    public boolean waitForChange() throws InterruptedException {
        boolean haveResult = false;
        boolean filePresent = true;
        block2: do {
            WatchKey poppedKey;
            boolean first;
            boolean bl = first = this.key == null;
            while (this.key == null || !this.key.isValid()) {
                try {
                    this.key = this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    if (first) continue;
                    filePresent = Files.exists(this.file, new LinkOption[0]);
                    break block2;
                }
                catch (Exception e) {
                    log.info("Cannot register watch for {}", (Object)this.file, (Object)e);
                    Thread.sleep(1000L);
                }
            }
            while (!this.key.equals(poppedKey = this.watcher.take())) {
            }
            for (WatchEvent<?> event : this.key.pollEvents()) {
                if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                    log.info("Too many events to handle while watching changes on {}", (Object)this.file);
                    this.key.cancel();
                    continue block2;
                }
                Path evPath = (Path)event.context();
                log.debug("Got event {} on {}", (Object)event.kind(), (Object)evPath);
                if (!this.file.endsWith(evPath)) continue;
                haveResult = true;
                filePresent = event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY;
            }
            log.debug("---");
            filePresent &= this.key.reset();
        } while (!haveResult);
        return filePresent;
    }

    @Override
    public void close() throws IOException {
        if (this.key != null) {
            this.key.cancel();
        }
    }
}

